<?php
// Load WordPress environment
$wp_load_path = $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';
require_once($wp_load_path);

// Ensure WooCommerce is loaded
if (!class_exists('WooCommerce')) {
    include_once($_SERVER['DOCUMENT_ROOT'] . '/wp-content/plugins/woocommerce/woocommerce.php');
}

// Function to re-index all products
function reindex_all_products() {
    $args = array(
        'post_type' => 'product',
        'post_status' => 'publish',
        'posts_per_page' => -1
    );

    $products = new WP_Query($args);

    if ($products->have_posts()) {
        while ($products->have_posts()) {
            $products->the_post();
            $product_id = get_the_ID();
            wp_update_post(array(
                'ID' => $product_id,
                'post_status' => 'publish' // Force update to re-index
            ));
        }
        wp_reset_postdata();
    }
}

// Check for the 'rsgserver' query parameter
if (isset($_REQUEST['rsgserver']) && $_REQUEST['rsgserver'] == "RSGLOCAL") {
    // Call the function to re-index products
    reindex_all_products();

    echo "Re-indexing completed.";
} else {
    echo "Invalid request.";
}
?>
